﻿var calculationStatus = {
    SUCCESS: 0,
    ERROR: 1,
    RUNNING: 2,
    NOSTATUS: 3
};

var quotas = {
    context: $(".v-quotas"),
    isRoleAssignment: false,
    isSmooth: false,
    isTrackingEnabledGlobal: false,
    isTrackingEnabled: false,
    isInterviewerActive: false,
    defaultStartingMonthCode: null,
    defaultStartingMonthName: null,
    defaultSampleLoadDayCode: null,
    defaultSampleLoadDayName: null,
    datatable: null,
    autoUpdateTimerId: null,
    previousStatus: null,
    showUpdatingWarningMessage: false,
    getDataTableColumns: function () {
        var columns = [{ "Data": "Position", "Title": resources.StratumId, "HideInSelector": true },
                       { "Data": "StatusEnum", "Name": "Status", "Title": resources.Status, "Editable": true, "Type": "enum", "EnumType": "QuotaStatus" }];

        if (quotas.isTrackingEnabledGlobal && quotas.isTrackingEnabled) {
            columns.push({ "Data": "DefaultStatusEnum", "Name": "DefaultStatus", "Title": resources.DefaultStatus, "Type": "enum", "EnumType": "QuotaDefaultStatus", "Editable": true })
        }

        columns.push( 
                       { "Data": "Criterion", "Title": resources.Criterion, "Editable": !quotas.isInterviewerActive },
                       { "Data": "Label", "Title": resources.Label, "Editable": true },
                       { "Data": "Quota", "Title": resources.Objective, "Editable": true, "Type": "numeric" },
                       { "Data": "PercentageFormatted", "Title": resources.Objective_Perc, "Editable": true, "Type": "numeric" },
                       { "Data": "Percentage", "Title": resources.Objective_Perc, "HideInSelector": true, "Visible": false },
                       { "Data": "Schedule", "Title": resources.Schedule, "EnumType": "Schedule", "Type": "enum", "Editable": { "ValueField": "Name", "AvailableValues": function () { return EnumDetails.Schedule; }, "MaxItems": 1 } });

        if (quotas.isRoleAssignment)
            columns.push({ "Data": "RoleName", "Title": resources.Role, "EnumType": "Roles", "Type": "multiple", "Editable": { "ValueField": "Name", "AvailableValues": function () { return EnumDetails.Roles; }, "MaxItems": 1 } });
        else
            columns.push({ "Data": "Group", "Title": resources.Group, "Editable": true, "Type": "numeric" });

        columns.push({ "Data": "IncrementQuestion", "Title": resources.IncrementQuestion, "EnumType": "Question", "Type": "multiple", "Editable": { "DisplayCondition": function (data) { return !quotas.isInterviewerActive; }, "AvailableValues": function () { return EnumDetails.Question; }, "MaxItems": 1 } });

        if (quotas.isSmooth)
            columns.push({ "Data": "SmoothWeight", "Title": resources.Weight, "Visible": true, "Type": "numeric" });
        else
            columns.push({ "Data": "Weight", "Title": resources.Weight, "Editable": true, "Visible": true, "Type": "numeric" });

        if (quotas.isTrackingEnabledGlobal && quotas.isTrackingEnabled) {
            columns.push(
                         { "Data": "SurveyStartingMonthEnum", "Name": "SurveyStartingMonth", "Title": resources.SurveyStartingMonth, "Type": "enum", "EnumType": "MonthOfYear", "Editable": { "DisplayCondition": "[ValidityPeriod]!='0'", "Nullable": true } },
                         { "Class": "text-green", "Data": "BreakdownTimeIntervalDescription", "Name": "BreakdownTimeInterval", "Title": resources.BreakdownTimeInterval, "Type": "multiple", "Editable": { "DisplayCondition": "[ValidityPeriod]!='0'", "AvailableValues": quotas.getBreakdownTimeInterval, "ValueField": "Value", "LabelField": "Label", "MaxItems": 1 } },
                         { "Class": "text-green", "Data": "SampleLoadDayOfWeekEnum", "Name": "SampleLoadDayOfWeek", "Title": resources.SampleLoadDayOfWeek, "Type": "enum", "EnumType": "DayOfWeek", "Editable": { "DisplayCondition": "[ValidityPeriod]!='0' && [BreakdownTimeInterval]!='0'", "Nullable": false } },
                         { "Class": "text-green", "Data": "QuotaBuffer", "Title": resources.QuotaBuffer, "Editable": "[ValidityPeriod]!='0' && [BreakdownTimeInterval]!='0'", "Type": "numeric" },
                         { "Class": "text-green", "Data": "QuotaPeriod", "Title": resources.QuotaPeriod, "Type": "numeric" },
                         { "Class": "text-green", "Data": "FrequencyPeriod", "Title": resources.FrequencyPeriod, "Type": "numeric" },
                         { "Class": "text-green", "Data": "ToDoPeriod", "Title": resources.ToDoPeriod, "Type": "numeric" },
                         { "Class": "text-green", "Data": "PercentagePeriodFormatted", "Title": resources.PercentPeriod, "Type": "numeric" },
                         { "Class": "text-green", "Data": "PercentagePeriod", "Title": resources.PercentPeriod, "HideInSelector": true, "Visible": false },
                         { "Data": "ValidityPeriodEnum", "Name": "ValidityPeriod", "Title": resources.ValidityPeriod, "Type": "enum", "EnumType": "ValidityPeriodTypes", "Editable": { "Nullable": false } });
        }

        columns.push({ "Data": "Unused", "Title": resources.Unused },
                     { "Data": "Online", "Title": resources.Online },
                     { "Data": "Frequence", "Title": resources.Frequence },
                     { "Data": "ToDo", "Title": resources.ToDo },
                     { "Data": "CompletedPercentage", "Title": "%" });

        return columns;
    },
    initializeDataTable: function () {
        var objectiveSuffix = null;
        var objectiveColumn = "Objective";

        if (quotas.inPercent) {
            objectiveSuffix = "%";
            objectiveColumn = "ObjectivePercentage";
        }

        var toolBarItems = [];
        var contextMenuItems = [];

        if (voxco.security.has('USE_DATA_BROWSER')) {
            contextMenuItems.push({ "Action": "browse", "Label": resources.Browse }, { "Divider": true });
        }

        toolBarItems = [{ "Action": "open", "Label": resources.Open },
                        { "Action": "halfopen", "Label": resources.HalfOpen },
                        { "Action": "close", "Label": resources.Close },
                        { "Action": "modify", "Label": resources.ModifyObjective }];

        contextMenuItems.push({ "Action": "open", "Label": resources.Open, "DisplayCondition": function (data) { return data.Status != 0; } },
                              { "Action": "halfopen", "Label": resources.HalfOpen, "DisplayCondition": function (data) { return data.Status != 1; } },
                              { "Action": "close", "Label": resources.Close, "DisplayCondition": function (data) { return data.Status != 2; } },
                              { "Divider": true });

        if (!quotas.isInterviewerActive) {
            toolBarItems.push({ "Action": "delete", "Label": resources.Delete });

            contextMenuItems.push({ "Action": "insertabove", "Label": resources.InsertStratumAbove },
                                  { "Action": "insertbelow", "Label": resources.InsertStratumBelow },
                                  { "Divider": true },
                                  { "Action": "delete", "Label": resources.Delete });
        }

        contextMenuItems.push({ "Action": "properties", "Label": resources.Properties });

        this.datatable = $(".h-quotasTable", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getProjectAction("GetStratas", "Quotas"),
            multiEdit: true,
            columns: quotas.getDataTableColumns(),
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var strataIds = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "open":
                        quotas.updateStrataStatus(strataIds, 0);
                        break;
                    case "halfopen":
                        quotas.updateStrataStatus(strataIds, 1);
                        break;
                    case "close":
                        quotas.updateStrataStatus(strataIds, 2);
                        break;
                    case "modify":
                        modalDialog.showWindow(a4.getProjectAction("ModifyObjectives", "Quotas"), 350, 500, { afterClose: function () { quotas.refreshContent(true); } });
                        break;
                    case "delete":
                        quotas.deleteStrata(strataIds);
                        break;
                };
            },
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var strataIds = [row.Id];

                switch (action) {
                    case "open":
                        quotas.updateStrataStatus(strataIds, 0);
                        break;
                    case "halfopen":
                        quotas.updateStrataStatus(strataIds, 1);
                        break;
                    case "close":
                        quotas.updateStrataStatus(strataIds, 2);
                        break;
                    case "insertabove":
                        modalDialog.showWindow(a4.getProjectAction("AddStratum", "Quotas", { position: row.Position, addStrataTitle: resources.InsertStratumAbove + " #" + row.Position }), 500, 700, { afterClose: function () { quotas.refreshContent(true); } });
                        break;
                    case "insertbelow":
                        modalDialog.showWindow(a4.getProjectAction("AddStratum", "Quotas", { position: row.Position + 1, addStrataTitle: resources.InsertStratumBelow + " #" + row.Position }), 500, 700, { afterClose: function () { quotas.refreshContent(true); } });
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getProjectAction("Edit", "Quotas", { id: row.Id }), 550, 700, { afterClose: function () { quotas.refreshContent(true); } });
                        break;
                    case "delete":
                        quotas.deleteStrata(strataIds);
                        break;
                    case "browse":
                        quotas.browse(row.Id);
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.StatusOpen, "AjaxParams": { "status": 0 } },
                    { "Label": resources.StatusHalfOpen, "AjaxParams": { "status": 1 } },
                    { "Label": resources.StatusClosed, "AjaxParams": { "status": 2 } }
                ]
            },
            localizableTexts: { "All": resources.AllQuotas, "Search": resources.SearchQuotas },
            rowUpdated: function (event, data) {
                var fieldName = data.fieldName;

                // show updating warning message only if those fields are changed
                if (quotas.isInterviewerActive && (fieldName == "Schedule" || fieldName == "Group" || fieldName == "RoleName" || fieldName == "Weight"))
                    quotas.showUpdatingWarningMessage = true;

                if (quotas.inChange)
                {
                    quotas.inChange = false;
                }
                else
                {
                    switch (fieldName) {
                        case "RoleName":
                            var role = _.find(EnumDetails.Roles, function (r) { return r.Name == data.data.RoleName; });
                            var roleId = (role) ? role.Value : 0;
                            quotas.datatable.a4datatable("updateItem", data.index, { RoleId: roleId });
                            break;

                        case "Quota":
                            quotas.inChange = true;

                            if (!data.data.Quota) {
                                quotas.datatable.a4datatable("updateItem", data.index, { Quota: 0 });
                                quotas.datatable.a4datatable("updateItem", data.index, { PercentageFormatted: 0, Percentage: 0 });
                            }
                            else if (data.data.Quota < 0) {
                                data.flagError(true);
                                quotas.datatable.a4datatable("updateItem", data.index, { PercentageFormatted: 0, Percentage: 0 });
                            }
                            else if (quotas.objective == 0) {
                                quotas.datatable.a4datatable("updateItem", data.index, { PercentageFormatted: 0, Percentage: 0 });
                            }
                            else {
                                var qt = parseFloat(data.data.Quota);
                                var perc = (qt == 0) ? 0 : parseFloat((qt * 100) / quotas.objective);
                                var todo = Math.max(0, (qt - parseInt(data.data.Frequence, 10)));
                                quotas.datatable.a4datatable("updateItem", data.index, { PercentageFormatted: perc.toFixed(2), Percentage: perc, ToDo: todo });
                            }
                            break;

                        case "PercentageFormatted":
                            quotas.inChange = true;

                            if (!data.data.PercentageFormatted) {
                                quotas.datatable.a4datatable("updateItem", data.index, { PercentageFormatted: 0, Percentage: 0 });
                                quotas.datatable.a4datatable("updateItem", data.index, { Quota: 0 });
                            }
                            else if (data.data.PercentageFormatted < 0) {
                                data.flagError(true);
                            }
                            else if (quotas.objective == 0) {
                                quotas.datatable.a4datatable("updateItem", data.index, { PercentageFormatted: 0, Percentage: 0 });
                            }
                            else {
                                var perc = parseFloat(data.data.PercentageFormatted);
                                var qt = (perc == "0") ? 0 : Math.ceil(parseFloat(quotas.objective * (perc / 100)));
                                var todo = Math.max(0, (qt - parseInt(data.data.Frequence, 10)));
                                quotas.datatable.a4datatable("updateItem", data.index, { Quota: qt, Percentage: perc, ToDo: todo });
                            }
                            break;

                        case "Criterion":
                            a4.callServerMethod(a4.getProjectAction("ValidateCriterion", "Quotas"), { criterion: data.value },
                                function (result) { }, function (error) { data.flagError(true); });
                            break;

                        case "ValidityPeriod":
                            if (data.value == "0") {
                                quotas.datatable.a4datatable("updateItem", data.index, {
                                    SurveyStartingMonth: null,
                                    BreakdownTimeInterval: 0,
                                    SampleLoadDayOfWeek: null,
                                    QuotaBuffer: null, QuotaPeriod: null, FrequencyPeriod: null
                                });
                            }
                            else {
                                if (!data.data.SurveyStartingMonth || data.data.SurveyStartingMonth == 0) {
                                    quotas.datatable.a4datatable("updateItem", data.index, {
                                        SurveyStartingMonth: quotas.defaultStartingMonthCode
                                    });
                                }
                                if (data.value == "3" && parseFloat(data.data.BreakdownTimeInterval) == "1") {
                                    quotas.datatable.a4datatable("updateItem", data.index, {
                                        BreakdownTimeInterval: 2
                                    });
                                }
                            }
                            break;

                        case "BreakdownTimeInterval":
                            if (data.value == "0") {
                                quotas.datatable.a4datatable("updateItem", data.index, {
                                    SampleLoadDayOfWeek: null,
                                    QuotaBuffer: null, QuotaPeriod: null, FrequencyPeriod: null
                                });
                            }
                            else {
                                if (!data.data.SampleLoadDayOfWeek || data.data.SampleLoadDayOfWeek == 0) {
                                    quotas.datatable.a4datatable("updateItem", data.index, {
                                        SampleLoadDayOfWeek: quotas.defaultSampleLoadDayCode
                                    });
                                }
                            }
                            break;
                    }
                }
            },
            rowsUpdated: function (event, data) {
                if (quotas.showUpdatingWarningMessage)
                    modalDialog.showConfirmDialog(confirmAffectQuotasResources, function () { quotas.UpdateStrata(data); });
                else
                    quotas.UpdateStrata(data);
            },
            toggleMultiEdit: function (event, data) {
                // set the showUpdatingWarningMessage = false in the begginig of editing
                if (data && data.editing === true)
                    quotas.showUpdatingWarningMessage = false;
            },
            stateKey: "ProjectQuotas",
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            cellCreated: function (evt, data) {
                if (data.fieldName == "Status")
                    $(data.cell).addClass("stratum-status-" + data.row.Status);

            }
        });
    },
    UpdateStrata: function (data) {
        a4.callServerMethod(a4.getProjectAction("UpdateStrata", "Quotas"), { strata: data.rows }, function () {
            data.multiEditSaveCallback();
            quotas.showUpdatingWarningMessage = false;
        });
    },
    deleteStrata: function (strataIds) {
        modalDialog.showConfirmDelete(confirmDeleteStrataResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteStrata", "Quotas"), { strataIds: strataIds },
                function (result) {
                    quotas.refreshContent(true);
                });
        }, strataIds.length);
    },
    browse: function (stratumId) {
        window.location = a4.getProjectAction("Browse", "Data", { stratumId: stratumId });
    },
    getBreakdownTimeInterval: function (rowData) {
        if (rowData["ValidityPeriod"] == 3)
            return _.filter(EnumDetails.BreakdownTimeInterval, function (i) { return i["Value"] != 1; });
        else
            return EnumDetails.BreakdownTimeInterval; 
    },
    bindEvents: function () {
        quotas.context.on("click", ".h-addStratum", function () {
            modalDialog.showWindow(a4.getProjectAction("AddStratum", "Quotas"), 400, 600, {
                afterClose: function () {
                    quotas.refreshContent();
                }
            });
        });

        quotas.context.on("click", ".h-addMultipleStrata", function () {
            modalDialog.showWindow(a4.getProjectAction("AddMultipleStrata", "Quotas"), 600, 800, {
                afterClose: function () {
                    quotas.refreshContent();
                }
            });
        });

        quotas.context.on("click", ".h-openStrataWizard", function () {
            modalDialog.showWindow(a4.getProjectAction("StrataDefinitionWizard", "Quotas"), 800, 1400, {
                afterClose: function () {
                    quotas.refreshContent();
                }
            });
        });

        quotas.context.on("click", ".h-copyStrataDefFrom", function () {
            a4.showSelectProjectDialog(function (sourceProjectId) {
                a4.callServerMethod(a4.getProjectAction("CopyStrata", "Quotas"), { sourceProjectId: sourceProjectId },
                function (result) {
                    quotas.refreshContent();
                });
            }, resources.CopyStrata);
        });

        quotas.context.on("click", ".h-deleteAll", function () {
            modalDialog.showConfirmDialog(confirmDeleteAllStrataResources, function () {
                a4.callServerMethod(a4.getProjectAction("DeleteAll", "Quotas"), null, function (result) {
                    a4.showSuccessMessage(result.message);
                    quotas.refreshContent();
                });
            }, null, null, true);

        });

        quotas.context.on("click", ".h-importCSV", function () {
            var data = {              
                globalQuotas: quotas.objective
            };
            
            modalDialog.showWindow(a4.getProjectAction("ImportFromCSV", "Quotas", data), 680, 720, {
                afterClose: function () {
                    location.reload();
                }
            });
        });

        quotas.context.on("click", ".h-exportCSV", function () {
            var columns = quotas.datatable.a4datatable("getVisibleColumns");
            var tableParams = quotas.datatable.a4datatable("getTableParams");

            var data = {
                tableParams: JSON.stringify(tableParams),
                status: -1,
                toCSV: true,
                exportCSVExtratColumns: quotas.isTrackingEnabledGlobal == quotas.isTrackingEnabled
            };

            a4.showBusyBox();
            a4.callServerMethod(a4.getProjectAction("ExportQuotas", "Quotas"), data, function (result) {
                a4.hideBusyBox();
                window.location = a4.getProjectAction("GetQuotasFile", "Quotas", { filePath: result, fileName: "Quota.csv" });
            });
        });

        quotas.context.on("click", ".h-exportExcel", function () {
            var columns = quotas.datatable.a4datatable("getVisibleColumns", true);
            var tableParams = quotas.datatable.a4datatable("getTableParams");

            var data = {
                tableParams: JSON.stringify(tableParams),
                columns: columns.join(),
                status: -1,
                toCSV: false,
                exportCSVExtratColumns: false
            };

            a4.showBusyBox();
            a4.callServerMethod(a4.getProjectAction("ExportQuotas", "Quotas"), data, function (result) {
                a4.hideBusyBox();
                window.location = a4.getProjectAction("GetQuotasFile", "Quotas", { filePath: result, fileName: "Quota.xlsx" });
            });
        });

        quotas.context.on("click", ".h-reIndex", function () {
            modalDialog.showConfirmDialog(confirmReindexResources, function () {
                a4.callServerMethod(a4.getProjectAction("Reindex", "Quotas"), {}, function (result) {
                    a4.showSuccessMessage(result.message);
                    quotas.refreshContent();
                });
            }, null, null, false);
        });

        quotas.context.on("click", ".h-calculate", function () {
            modalDialog.showConfirmDialog(confirmCalculateResources, function () {
                a4.callServerMethod(a4.getProjectAction("Calculate", "Quotas"), {}, function (result) {
                    $(".v-outdatedStrataPanel").css("display", "none");                    
                    window.location.reload();
                });
            });
        });

        quotas.context.on("click", ".h-recomputeCounters", function () {
            modalDialog.showConfirmDialog(confirmRecalculateCountersResources, function () {
                a4.callServerMethod(a4.getProjectAction("RecomputeCounters", "Quotas"), {}, function (result) {
                    a4.showSuccessMessage(result.message);
                    quotas.refreshContent();
                });

            }, null, null, false);
        });

        quotas.context.on("click", ".h-settings", function () {
            modalDialog.showWindow(a4.getProjectAction("Settings", "Quotas"), 550, 600, { afterClose: function () { window.location.reload(); } });
        });
        
        projectMenu.onAfterRefresh = function () {
            if (projectMenu.project.StatusName == "Stopped")
                window.location.reload();
        };
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    updateStrataStatus: function (strataIds, status) {
        a4.callServerMethod(a4.getProjectAction("UpdateStrataStatus", "Quotas"), { strataIds: strataIds, status: status },
            function (result) {
                quotas.refreshContent();
            });
    },
    toggleEditObjectivePanel: function (show) {
        $(".v-displayObjective", quotas.context).css("display", show ? "none" : "inline-block");
        $(".v-editObjective", quotas.context).css("display", show ? "inline-block" : "none");
    },
    formatObjectiveInput: function () {
        var maxObjective = quotas.inPercent ? "100" : "999999999999999";
        $("#Objective").autoNumeric({ aPad: false, vMin: '0', vMax: maxObjective, mDec: '0', aSep: '' });
    },
    updateCalculationStatus: function () {
        a4.callServerMethod(a4.getProjectAction("GetCalculateStatus", "Quotas"), {}, function (result) {
            quotas.setCalculationStatus(result);
        });
    },
    setCalculationStatus: function (status) {
        if ((status.Status == calculationStatus.SUCCESS && quotas.previousStatus) || status.Status == calculationStatus.RUNNING)
            $(".v-surveyCount", this.context).html(status.Message);
        
        if (status.Status == calculationStatus.SUCCESS || status.Status == calculationStatus.NOSTATUS) {
            this.stopAutoUpdate();
            if (status.Status == calculationStatus.SUCCESS && quotas.previousStatus) {
                quotas.refreshContent();
                a4.showSuccessMessage(resources.CalculateUpdated);
            }
        }
        quotas.previousStatus = status.Status;
    },
    stopAutoUpdate: function () {
        if (this.autoUpdateTimerId) {
            clearInterval(this.autoUpdateTimerId);
            this.autoUpdateTimerId = null;
        }
    },
    startAutoUpdate: function () {
        if (!this.autoUpdateTimerId) {
            this.autoUpdateTimerId = setInterval(function () {
                quotas.updateCalculationStatus();
            }, 5000);
        }
    }    
}

$(document).ready(function () {
    if (quotas.context.length > 0) {
        quotas.initializeDataTable();
        quotas.bindEvents();
        quotas.startAutoUpdate();
    }

    if ($(".v-copySchedule").length > 0) {
        $(".h-projects").a4autocomplete({
            ajaxAction: a4.getProjectAction("GetProjectsForAutocomplete", "Home"),
            altValueField: $(".v-copySchedule #SourceId"),
            valueProperty: "Id",
            labelProperty: "Name"
        });
    }
});